/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.buffer;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.model.CachedFormat;
import codechicken.lib.model.Quad;
import codechicken.lib.render.buffer.ISpriteAwareVertexConsumer;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class BakedQuadVertexBuilder
implements VertexConsumer,
ISpriteAwareVertexConsumer {
    private final List<Quad> quadList = new ArrayList<Quad>();
    private final int glMode;
    private final int vSize;
    private CachedFormat format = CachedFormat.lookup(DefaultVertexFormat.f_85811_);
    private Colour defaultColour;
    private Quad current;
    private int vertex;

    public BakedQuadVertexBuilder() {
        this(7);
    }

    public BakedQuadVertexBuilder(int glMode) {
        if (glMode != 7 && glMode != 4) {
            throw new IllegalArgumentException("Only GL_QUADS and GL_TRIANGLES supported. Got: " + glMode);
        }
        this.glMode = glMode;
        this.vSize = glMode == 7 ? 4 : 3;
    }

    public void setFormat(VertexFormat format) {
        this.setFormat(CachedFormat.lookup(format));
    }

    public void setFormat(CachedFormat format) {
        this.format = format;
    }

    public void reset() {
        this.quadList.clear();
        this.current = null;
        this.vertex = 0;
    }

    @Override
    public void sprite(TextureAtlasSprite sprite) {
        this.checkNewQuad();
        this.current.setTexture(sprite);
    }

    public VertexConsumer m_5483_(double x, double y, double z) {
        if (!this.format.hasPosition) {
            return this;
        }
        this.checkNewQuad();
        this.current.vertices[this.vertex].vec[0] = (float)x;
        this.current.vertices[this.vertex].vec[1] = (float)y;
        this.current.vertices[this.vertex].vec[2] = (float)z;
        return this;
    }

    public VertexConsumer m_6122_(int red, int green, int blue, int alpha) {
        if (!this.format.hasColor) {
            return this;
        }
        this.checkNewQuad();
        this.current.vertices[this.vertex].color[0] = (float)red / 255.0f;
        this.current.vertices[this.vertex].color[1] = (float)green / 255.0f;
        this.current.vertices[this.vertex].color[2] = (float)blue / 255.0f;
        this.current.vertices[this.vertex].color[3] = (float)alpha / 255.0f;
        return this;
    }

    public VertexConsumer m_7421_(float u, float v) {
        if (!this.format.hasUV) {
            return this;
        }
        this.checkNewQuad();
        this.current.vertices[this.vertex].uv[0] = u;
        this.current.vertices[this.vertex].uv[1] = v;
        return this;
    }

    public VertexConsumer m_7122_(int u, int v) {
        if (!this.format.hasOverlay) {
            return this;
        }
        this.checkNewQuad();
        this.current.vertices[this.vertex].overlay[0] = (float)u / 240.0f;
        this.current.vertices[this.vertex].overlay[1] = (float)v / 240.0f;
        return this;
    }

    public VertexConsumer m_7120_(int u, int v) {
        if (!this.format.hasLightMap) {
            return this;
        }
        this.checkNewQuad();
        this.current.vertices[this.vertex].lightmap[0] = (float)u / 240.0f;
        this.current.vertices[this.vertex].lightmap[1] = (float)v / 240.0f;
        return this;
    }

    public VertexConsumer m_5601_(float x, float y, float z) {
        if (!this.format.hasNormal) {
            return this;
        }
        this.checkNewQuad();
        this.current.vertices[this.vertex].normal[0] = x;
        this.current.vertices[this.vertex].normal[1] = y;
        this.current.vertices[this.vertex].normal[2] = z;
        return this;
    }

    public void m_5752_() {
        ++this.vertex;
        if (this.vertex == this.vSize) {
            if (this.glMode == 4) {
                for (int e = 0; e < this.current.format.elementCount; ++e) {
                    System.arraycopy(this.current.vertices[2].raw[e], 0, this.current.vertices[3].raw[e], 0, 4);
                }
            }
            if (this.current.sprite == null) {
                throw new IllegalStateException("Sprite not set.");
            }
            if (this.defaultColour != null) {
                float[] colour = this.defaultColour.getRGBA();
                for (Quad.Vertex v : this.current.vertices) {
                    System.arraycopy(colour, 0, v.color, 0, 4);
                }
            }
            this.quadList.add(this.current);
            this.current = null;
            this.vertex = 0;
        }
    }

    public void m_142461_(int r, int g, int b, int a) {
        this.defaultColour = new ColourRGBA(r, g, b, a);
    }

    public void m_141991_() {
        this.defaultColour = null;
    }

    public List<BakedQuad> bake() {
        if (this.current != null) {
            throw new IllegalStateException("Not finished building.");
        }
        return this.quadList.stream().map(Quad::bake).collect(Collectors.toList());
    }

    private void checkNewQuad() {
        if (this.current == null) {
            this.current = new Quad(this.format);
        }
    }
}

